// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/ui/webui/omnibox/omnibox.mojom
//

package org.chromium.mojom;

public final class AutocompleteAdditionalInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public String key;
    public String value;

    private AutocompleteAdditionalInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public AutocompleteAdditionalInfo() {
        this(0);
    }

    public static AutocompleteAdditionalInfo deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static AutocompleteAdditionalInfo decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        AutocompleteAdditionalInfo result = new AutocompleteAdditionalInfo(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.key = decoder0.readString(8, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.value = decoder0.readString(16, false);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(key, 8, false);
        encoder0.encode(value, 16, false);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        AutocompleteAdditionalInfo other = (AutocompleteAdditionalInfo) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.key, other.key))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.value, other.value))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(key);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(value);
        return result;
    }
}

